IF OBJECT_ID('EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD') IS NULL
	BEGIN

		CREATE TABLE [dbo].[EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD](
			[CD_EMP] [int] NOT NULL,
			[CD_TBL_DESC] [int] NOT NULL,
			[CD_PROD] [int] NOT NULL,
			[CD_FAIXA] [int] NOT NULL,
			[VLR_INI] [money] NOT NULL,
			[VLR_FIM] [money] NOT NULL,
			[PERC_DESC] [money] NOT NULL,
			[PERC_DESC_MAX] [money] NOT NULL,	
		 CONSTRAINT [PK_EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD] PRIMARY KEY CLUSTERED 
		(
			[CD_EMP] ASC,
			[CD_TBL_DESC] ASC,
			[CD_PROD] ASC,
			[CD_FAIXA] ASC
		)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
		) ON [PRIMARY]

		

		ALTER TABLE [dbo].[EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD] ADD  CONSTRAINT [DF_EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD_PERC_DESC]  DEFAULT ((0)) FOR [PERC_DESC]
		

		ALTER TABLE [dbo].[EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD] ADD  CONSTRAINT [DF_EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD_PERC_DESC_REC]  DEFAULT ((0)) FOR [PERC_DESC_MAX]
		

		ALTER TABLE [dbo].[EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD] ADD  CONSTRAINT [DF_EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD_VLR_INI]  DEFAULT ((0)) FOR [VLR_INI]
		

		ALTER TABLE [dbo].[EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD] ADD  CONSTRAINT [DF_EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD_VLR_FIM]  DEFAULT ((0)) FOR [VLR_FIM]
		
		ALTER TABLE [dbo].[EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD_EST_PROD] FOREIGN KEY([CD_EMP],[CD_PROD])
		REFERENCES [dbo].[EST_PROD] ([CD_EMP],[CD_PROD])
		ON UPDATE CASCADE
		

		ALTER TABLE [dbo].[EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD] CHECK CONSTRAINT [FK_EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD_EST_PROD]
		

		ALTER TABLE [dbo].[EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD_EST_PROD_TBL_DESC] FOREIGN KEY([CD_EMP], [CD_TBL_DESC])
		REFERENCES [dbo].[EST_PROD_TBL_DESC] ([CD_EMP], [CD_TBL_DESC])
		ON UPDATE CASCADE
		ON DELETE CASCADE
		

		ALTER TABLE [dbo].[EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD] CHECK CONSTRAINT [FK_EST_PROD_TBL_DESC_FAIXA_PRC_EST_PROD_EST_PROD_TBL_DESC]
		

	END
